//
//  WebViewController.swift
//  Integration
//
//  Created by NurWork on 23/11/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//

import UIKit
import WebKit


class WebViewController: UIViewController, WKNavigationDelegate {

    var webView: WKWebView!
    var path:String = ""
    var progressView:UIProgressView! //Float 0-1
    
    
    override func loadView() {
        super.loadView()
        
        webView = WKWebView()
        webView.navigationDelegate = self
        view = webView
        
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        if path.isEmpty
        {
            path = "https://developer.apple.com/"
        }
        
        let url = NSURL(string: path)!
        webView.loadRequest(NSURLRequest(URL: url))
        webView.allowsBackForwardNavigationGestures = true // swipe from the left or right edge for browsing
        
        //KVO observer side; step 1/3
        webView.addObserver(self, forKeyPath: "estimatedProgress", options: .New, context: nil)
        
        navigationItem.rightBarButtonItem = UIBarButtonItem(barButtonSystemItem: .Refresh, target: webView, action: "reload") //webView.reload()
        
        progressView = UIProgressView(progressViewStyle: .Bar)
        progressView.sizeToFit()
        let progressBar = UIBarButtonItem(customView: progressView) //all UIToolBar itms must be embedded in UIBarButtonItem(s)
        let spacer = UIBarButtonItem(barButtonSystemItem: .FlexibleSpace, target: nil, action: nil)
        toolbarItems = [spacer,progressBar,spacer]
        navigationController?.toolbarHidden = false


    }
    
    override func viewDidDisappear(animated: Bool) {
        super.viewDidDisappear(animated)
        //KVO observer side; step 3/3
        webView.removeObserver(self, forKeyPath: "estimatedProgress")

    }
    

   
    
    //MARK: Delegation
    
    func webView(webView: WKWebView, didFinishNavigation navigation: WKNavigation!) {
        title = webView.title
    }
    
    func webView(webView: WKWebView, decidePolicyForNavigationAction navigationAction: WKNavigationAction, decisionHandler: (WKNavigationActionPolicy) -> Void) {
        
        decisionHandler(.Allow)
        /*
        let targetURL = navigationAction.request.URL
        
        if let host = targetURL!.host {
            if host.rangeOfString(path) != nil {
                decisionHandler(.Allow)
                return
            }
        }
        
        decisionHandler(.Cancel)
        
        let alertController = UIAlertController(title: "Navigation not allowed", message: "Cannot navigate beyond this host.", preferredStyle: .Alert)
        
        alertController.addAction(UIAlertAction(title: "OK", style: .Default, handler: nil))
        
        presentViewController(alertController,animated: true, completion: nil)
        */
    }

    
    //MARK: KVO
    
    //KVO observer side; step 2/3
    override func observeValueForKeyPath(keyPath: String?, ofObject object: AnyObject?, change: [String : AnyObject]?, context: UnsafeMutablePointer<Void>) {
        if keyPath == "estimatedProgress" {
            progressView.progress = Float(webView.estimatedProgress)
        }
    }

    
   
    
    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
